﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.WebUI.Admin.Helpers;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.Color
{
    public partial class Colors : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindProductColorList(string.Empty);
            }
        }

        private void BindProductColorList(string searchWord)
        {
            List<ProductColor> pcList = ProductColorBL.GetList(Guid.Empty, searchWord);
            pcList = (from pb in pcList
                      where pb.IsActive
                      orderby pb.ColorName ascending
                      select pb).ToList<ProductColor>();
            grdProductColor.DataSource = pcList;//.OrderBy(reg => reg.SequenceNo);
            grdProductColor.DataBind();

            if (pcList.Count == 0)
                WebUtilities.ShowMessage(this, "No Product Color found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindProductColorList(string.Empty);
            Master.ExportToExcel<Entities.ProductColor>(grdProductColor, "ColorsReport");
        }

        protected void grdProductColor_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdProductColor.PageIndex = e.NewPageIndex;
            BindProductColorList(txtSearch.Text.Trim());
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtSearch.Text.Trim().Length == 0)
            {
                WebUtilities.ShowMessage(this, "Please enter the search word");
                return;
            }
            BindProductColorList(txtSearch.Text.Trim());
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindProductColorList(string.Empty);
        }
    }
}